<?php
/**
 * Theme functions and definitions.
 *
 * For additional information on potential customization options,
 * read the developers' documentation:
 *
 * https://developers.elementor.com/docs/hello-elementor-theme/
 *
 * @package HelloElementorChild
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

define( 'HELLO_ELEMENTOR_CHILD_VERSION', '2.0.0' );

/**
 * Load child theme scripts & styles.
 *
 * @return void
 */
function hello_elementor_child_scripts_styles() {

	wp_enqueue_style(
		'hello-elementor-child-style',
		get_stylesheet_directory_uri() . '/style.css',
		[
			'hello-elementor-theme-style',
		],
		HELLO_ELEMENTOR_CHILD_VERSION
	);

}
add_action( 'wp_enqueue_scripts', 'hello_elementor_child_scripts_styles', 20 );







/** افزودن توضیح دوم دسته**/


// 1. Display field on "Add new product category" admin page

add_action( 'product_cat_add_form_fields', 'themefars_wp_editor_add', 10, 2 );

function themefars_wp_editor_add() {
?>
<div class="form-field">
	<label for="seconddesc"><?php echo __( 'Second Description', 'woocommerce' ); ?></label>
	
	<?php
		$settings = array(
		'textarea_name' => 'seconddesc',
		'quicktags' => array( 'buttons' => 'em,strong,link' ),
		'tinymce' => array(
		'theme_advanced_buttons1' => 'bold,italic,strikethrough,separator,bullist,numlist,separator,blockquote,separator,justifyleft,justifycenter,justifyright,separator,link,unlink,separator,undo,redo,separator',
		'theme_advanced_buttons2' => '',
		),
		'editor_css' => '<style>#wp-excerpt-editor-container .wp-editor-area{height:175px; width:100%;}</style>',
		);
		
		wp_editor( '', 'seconddesc', $settings );
	?>
	
	<p class="description"><?php echo __( 'This is the description that goes BELOW products on the category page', 'woocommerce' ); ?></p>
</div>
<?php
}

// ---------------
// 2. Display field on "Edit product category" admin page

add_action( 'product_cat_edit_form_fields', 'themefars_wp_editor_edit', 10, 2 );

function themefars_wp_editor_edit( $term ) {
	$second_desc = htmlspecialchars_decode( get_woocommerce_term_meta( $term->term_id, 'seconddesc', true ) );
?>
<tr class="form-field">
	<th scope="row" valign="top"><label for="second-desc"><?php echo __( 'توضیحات دوم', 'woocommerce' ); ?></label></th>
	<td>
		<?php
			
			$settings = array(
			'textarea_name' => 'seconddesc',
			'quicktags' => array( 'buttons' => 'em,strong,link' ),
			'tinymce' => array(
			'theme_advanced_buttons1' => 'bold,italic,strikethrough,separator,bullist,numlist,separator,blockquote,separator,justifyleft,justifycenter,justifyright,separator,link,unlink,separator,undo,redo,separator',
			'theme_advanced_buttons2' => '',
			),
			'editor_css' => '<style>#wp-excerpt-editor-container .wp-editor-area{height:175px; width:100%;}</style>',
			);
			
			wp_editor( $second_desc, 'seconddesc', $settings );
		?>
		
		<p class="description"><?php echo __( 'This is the description that goes BELOW products on the category page', 'woocommerce' ); ?></p>
	</td>
</tr>
<?php
}

// ---------------
// 3. Save field @ admin page

add_action( 'edit_term', 'themefars_save_wp_editor', 10, 3 );
add_action( 'created_term', 'themefars_save_wp_editor', 10, 3 );

function themefars_save_wp_editor( $term_id, $tt_id = '', $taxonomy = '' ) {
	if ( isset( $_POST['seconddesc'] ) && 'product_cat' === $taxonomy ) {
		update_woocommerce_term_meta( $term_id, 'seconddesc', esc_attr( $_POST['seconddesc'] ) );
	}
}

// ---------------
// 4. Display field under products @ Product Category pages

///add_action( 'woocommerce_after_shop_loop', 'themefars_display_wp_editor_content', 5 );

function themefars_display_wp_editor_content() {
	if ( is_product_taxonomy() ) {
		$term = get_queried_object();
		if ( $term && ! empty( get_woocommerce_term_meta( $term->term_id, 'seconddesc', true ) ) ) {
			echo '<p class="term-description">' . wc_format_content( htmlspecialchars_decode( get_woocommerce_term_meta( $term->term_id, 'seconddesc', true ) ) ) . '</p>';
		}
	}
}

// register shortcode
add_shortcode('second-des-woocommerce', 'themefars_display_wp_editor_content');



///افزودن دکمه مثبت و منفی در خرید محصول

// 1. Show plus minus buttons

add_action( 'woocommerce_after_quantity_input_field', 'themefars_display_quantity_minus' );

function themefars_display_quantity_minus() {
echo '<button type="button" class="minus"><div  class="minus-text">-</div></button>';
}



add_action( 'woocommerce_before_quantity_input_field', 'themefars_display_quantity_plus' );
function themefars_display_quantity_plus() {
echo '<button type="button" class="plus"><div class="plus-text">+</div></button>';
}


// -------------
// 2. Trigger update quantity script

add_action( 'wp_footer', 'themefars_add_cart_quantity_plus_minus' );

function themefars_add_cart_quantity_plus_minus() {

if ( ! is_product() && ! is_cart() ) return;

wc_enqueue_js( " 

$(document).on( 'click', 'button.plus, button.minus', function() {

var qty = $( this ).parent( '.quantity' ).find( '.qty' );
var val = parseFloat(qty.val());
var max = parseFloat(qty.attr( 'max' ));
var min = parseFloat(qty.attr( 'min' ));
var step = parseFloat(qty.attr( 'step' ));

if ( $( this ).is( '.plus' ) ) {
if ( max && ( max <= val ) ) {
qty.val( max ).change();
} else {
qty.val( val + step ).change();
}
} else {
if ( min && ( min >= val ) ) {
qty.val( min ).change();
} else if ( val > 1 ) {
qty.val( val - step ).change();
}
}

});

" );
}


// show discount product for   elementor
function show_product_discount_percentage() {
    global $product;

    if ( $product->is_type( 'variable' ) ) {
        // محصول متغیر است
        $variations = $product->get_available_variations();
        $max_discount = 0;

        foreach ( $variations as $variation ) {
            $regular_price = $variation['display_regular_price'];
            $sale_price = $variation['display_price'];

            if ( $regular_price > $sale_price ) {
                $discount_percentage = round( ( ( $regular_price - $sale_price ) / $regular_price ) * 100 );
                $max_discount = max( $max_discount, $discount_percentage );
            }
        }

        if ( $max_discount > 0 ) {
            return '<span class="sale-percentage">' . $max_discount . '%</span>';
        } else {
            return '';
        }
    } else {
        // محصول ساده است
        if ( $product->is_on_sale() ) {
            $regular_price = $product->get_regular_price();
            $sale_price = $product->get_sale_price();
            $discount_percentage = round( ( ( $regular_price - $sale_price ) / $regular_price ) * 100 );

            return '<span class="sale-percentage">' . $discount_percentage . '%</span>';
        } else {
            return '';
        }
    }
}
add_shortcode( 'product_discount_percentageee', 'show_product_discount_percentage' );





/// محصول ناموجود به انتهای لیست
add_action( 'woocommerce_product_query','hide_out_of_stock' );
function hide_out_of_stock( $q ) {
	$q->set( 'orderby', 'meta_value' );
	$q->set( 'meta_key', '_stock_status' );
	$q->set( 'order', 'ASC' );
}




